--
-- test_cln_advance.sql
--
-- CLEAN_Address_APP Test Script.  Test the individual procedure call for verifying
-- a address in your custom application using CLEAN_Address
--
-- History:
--   10/27/2015 Created
--   10/27/2015 Added lv_suggestion_list variable
--
-- Copyright (c) 2011 Runner Technologies, Inc.  All Rights Reserved.
--
declare 
  l_ADDRESS_rec                  CLN_ADDRESSES%ROWTYPE;
  l_CLN_ADDRESS_APP_rec          CLN_ADDRESS_APP%ROWTYPE;
  lv_address_error_text          VARCHAR2(200);
  lv_plsql_error                 VARCHAR2(200);
  lv_suggestion_list             VARCHAR2(2000);
  lv_CARRIER_ROUTE               VARCHAR2(10);
  lv_ADDRESS_ERROR_CODE          VARCHAR2(10);
  ld_ADDRESS_VERIFIED_DATE       DATE;
  ln_latitude                    NUMBER;
  ln_longitude                   NUMBER;
  lv_address_type                VARCHAR2(2000);
  --lv_address                     VARCHAR2(2000);
  --lv_suite                       VARCHAR2(2000);
begin
  dbms_output.enable(1000000);
  --------------------------------------------------------------------------------------------
  -- Assign the input variables
  --------------------------------------------------------------------------------------------
  --l_ADDRESS_rec.CARE_OF      := 'shipping department';
  --l_ADDRESS_rec.COMPANY_NAME := 'Runner Technologies, Inc.';
  l_ADDRESS_rec.ADDRESS_LINE_1 := '6530 W ROGERS cir';  --'804 Chestnut Street';
  l_ADDRESS_rec.ADDRESS_LINE_2 := 'ste 31'; --'P. O. Box 1194';
  l_ADDRESS_rec.ADDRESS_LINE_3 := ''; -- NULL;
  l_ADDRESS_rec.CITY       	   := '';
  l_ADDRESS_rec.STATE 		   := '';
  l_ADDRESS_rec.POSTAL_CODE    := '33487';
  --
  -- Display the Input
  --
  dbms_output.put_line ('----------------------------------------------------------');
  dbms_output.put_line ('INPUT');
  dbms_output.put_line ('----------------------------------------------------------');
  --dbms_output.put_line ('CARE_OF     : '||l_ADDRESS_rec.CARE_OF);
  --dbms_output.put_line ('COMPANY_1   : '||l_ADDRESS_rec.COMPANY_NAME_1);
  dbms_output.put_line ('ADDRESS_LINE_1     : '||l_ADDRESS_rec.ADDRESS_LINE_1);
  dbms_output.put_line ('ADDRESS_LINE_2     : '||l_ADDRESS_rec.ADDRESS_LINE_2);
  dbms_output.put_line ('ADDRESS_LINE_3     : '||l_ADDRESS_rec.ADDRESS_LINE_3);
  dbms_output.put_line ('CITY        		: '||l_ADDRESS_rec.CITY);
  dbms_output.put_line ('STATE   			: '||l_ADDRESS_rec.STATE);
  dbms_output.put_line ('POSTAL_CODE        : '||l_ADDRESS_rec.POSTAL_CODE);
  --------------------------------------------------------------------------------------------
  -- Call the CLEAN_Address APP Verify procedure
  --------------------------------------------------------------------------------------------
  --
  -- FIRST METHOD - Pass in the APP Record Type
  --
  CLEAN_Address_APP.Verify_CLN_ADDRESSES_Record(
           f_ADDRESS_rec             => l_ADDRESS_rec
          ,f_CLN_ADDRESS_APP_rec => l_CLN_ADDRESS_APP_rec
          ,address_error_text        => lv_address_error_text
          ,fv_plsql_error            => lv_plsql_error
          );
  lv_CARRIER_ROUTE          := l_CLN_ADDRESS_APP_rec.carrier_route;
  ln_latitude               := l_CLN_ADDRESS_APP_rec.latitude;
  ln_longitude              := l_CLN_ADDRESS_APP_rec.longitude;
  lv_ADDRESS_ERROR_CODE     := l_CLN_ADDRESS_APP_rec.ADDRESS_ERROR_CODE;
  ld_ADDRESS_VERIFIED_DATE  := l_CLN_ADDRESS_APP_rec.ADDRESS_VERIFIED_DATE;
  --
  -- OR
  --
  -- SECOND METHOD - Pass in the individual column names
  --
--  CLEAN_Address_APP.Verify (
--          ,company_name                => l_address_rec.COMPANY_NAME_1
--          ,address_1                   => l_ADDRESS_rec.ADDRESS_LINE_1
--          ,address_2                   => l_ADDRESS_rec.ADDRESS_LINE_2
--          ,address_3                   => l_ADDRESS_rec.ADDRESS_LINE_3
--          ,city                        => l_ADDRESS_rec.CITY
--          ,state                       => l_ADDRESS_rec.STATE
--          ,postal_code                 => l_ADDRESS_rec.POSTAL_CODE
--          ,county_code                 => l_ADDRESS_rec.COUNTY_NAME
--          ,country_code                => l_ADDRESS_rec.COUNTRY_NAME
--          ,last_line                   => l_ADDRESS_rec.last_line
--          ,postnet_barcode             => l_ADDRESS_rec.postnet_barcode
--          ,carrier_route               => lv_CARRIER_ROUTE
--          ,latitude                    => ln_latitude
--          ,longitude                   => ln_longitude
--          ,address_error_code          => lv_ADDRESS_ERROR_CODE
--          ,address_verified_date       => ld_ADDRESS_VERIFIED_DATE
--          ,address_error_text          => lv_address_error_text
--          ,fv_plsql_error              => lv_plsql_error
--          ,fv_address_type			 => lv_address_type
--          ,fv_suggestion_list          => lv_suggestion_list
--          --,fv_address				 => lv_address
--          --,fv_suite					 => lv_suite
--          );
  --------------------------------------------------------------------------------------------
  -- Display the output variables
  --------------------------------------------------------------------------------------------
  dbms_output.put_line ('----------------------------------------------------------');
  dbms_output.put_line ('OUTPUT');
  dbms_output.put_line ('----------------------------------------------------------');
  --dbms_output.put_line ('CARE_OF            : '||l_ADDRESS_rec.CARE_OF);
  --dbms_output.put_line ('COMPANY_NAME       : '||l_ADDRESS_rec.COMPANY_NAME);
  dbms_output.put_line ('ADDRESS_LINE_1       : '||l_ADDRESS_rec.ADDRESS_LINE_1);
  dbms_output.put_line ('ADDRESS_LINE_2       : '||l_ADDRESS_rec.ADDRESS_LINE_2);
  dbms_output.put_line ('ADDRESS_LINE_3       : '||l_ADDRESS_rec.ADDRESS_LINE_3);
  dbms_output.put_line ('CITY                 : '||l_ADDRESS_rec.CITY);
  dbms_output.put_line ('STATE_CODE           : '||l_ADDRESS_rec.STATE);
  dbms_output.put_line ('POSTAL_CODE          : '||l_ADDRESS_rec.POSTAL_CODE);
  dbms_output.put_line ('COUNTY               : '||l_ADDRESS_rec.COUNTY_NAME);
  dbms_output.put_line ('COUNTRY_CODE         : '||l_ADDRESS_rec.COUNTRY_NAME);
  dbms_output.put_line ('CARRIER_ROUTE        : '||lv_CARRIER_ROUTE);
  dbms_output.put_line ('LATITUDE             : '||to_char(ln_latitude));
  dbms_output.put_line ('LONGITUDE            : '||to_char(ln_longitude));
  dbms_output.put_line ('ADDRESS_ERROR_CODE   : '||lv_ADDRESS_ERROR_CODE);
  dbms_output.put_line ('ADDR_VERIFIED_DATE   : '||ld_ADDRESS_VERIFIED_DATE);
  dbms_output.put_line ('Address Error Text   : '||lv_address_error_text);
  dbms_output.put_line ('fv_plsql_error       : '||lv_plsql_error);
  --
  -- Check for a non-deliverable address
  --
  if lv_ADDRESS_ERROR_CODE IS NOT NULL then
    dbms_output.put_line ('Verification Error: '
               ||to_char(ld_ADDRESS_VERIFIED_DATE, 'MM/DD/YYYY')
               ||' : '
               ||lv_ADDRESS_ERROR_CODE
               ||' - '
               ||CLEAN_Address_Advance.Get_Error_Text(lv_ADDRESS_ERROR_CODE)
               );
  end if;
end;
/
